local cursor_move_sfx, choice_made_sfx
local Wheel = setmetatable({}, sick_wheel_mt)

local Choices = {
	{
		text=THEME:GetString("Pause", "Return"),
		action=function()
			local topscreen = SCREENMAN:GetTopScreen()
			topscreen:SetNextScreenName("Overworld")
			topscreen:GetChild("Overlay"):queuecommand("TransitionScreen")
		end,
	},
	{
		text=THEME:GetString("Pause", "Title"),
		action=function()
			local topscreen = SCREENMAN:GetTopScreen()
			topscreen:SetNextScreenName("Title")
			topscreen:GetChild("Overlay"):queuecommand("TransitionScreen")
		end,
	},
	-- {
	-- 	text=THEME:GetString("Pause", "Save"),
	-- 	action=function()
	-- 		local f = RageFileUtil.CreateRageFile()
	--
	-- 		if f:Open( THEME:GetPathO("","SaveStates") .. "/SaveState.lua" , 2) then
	-- 			f:Write( TableToString_Recursive(SRT.Player, "SRT") )
	-- 			choice_made_sfx:play()
	-- 		else
	-- 			local fError = f:GetError()
	-- 			Trace( "[FileUtils] Error writing to disk: ".. fError )
	-- 			f:ClearError()
	-- 		end
	-- 		f:destroy()
	--
	-- 		local topscreen = SCREENMAN:GetTopScreen()
	-- 		topscreen:SetNextScreenName("Overworld")
	-- 		topscreen:GetChild("Overlay"):queuecommand("TransitionScreen")
	-- 	end,
	-- },
}


-- the metatable for a choice in the wheel
local wheel_item_mt = {
	__index = {
		create_actors = function(self, name)
			self.name=name

			local af = Def.ActorFrame{
				Name=self.name,
				InitCommand=function(subself)
					self.container = subself
				end,
				OnCommand=function(subself)
					subself:y( self.index * 30 )
				end,
			}

			af[#af+1] = Def.BitmapText{
				Font="Common normal",
				InitCommand=function(subself)
					self.bmt = subself
					subself:zoom(0.75):halign(0)
						:diffuse(1,1,1,1)
						:wrapwidthpixels(_screen.w/3)
				end,
			}

			return af
		end,

		transform = function(self, item_index, num_items, has_focus)
			self.container:finishtweening()
			self.container:linear(0.2)

			if has_focus then
				self.container:diffusealpha(1)
			else
				self.container:diffusealpha(0.33)
			end

			self.bmt:settext( self.text )

		end,

		set = function(self, choice)
			if not choice then return end

			self.index = FindInTable(choice, Choices)
			self.text = choice.text
			self.action = choice.action
		end
	}
}


---------------------------------------------------------------------
-- Initialize generalized Event Handling function(s)
---------------------------------------------------------------------

local InputHandler = function(event)

	-- if any of these, don't attempt to handle input
	if not event.PlayerNumber or not event.button then
		return false
	end

	if event.type == "InputEventType_FirstPress" then

		if event.GameButton == "MenuRight" or event.GameButton == "MenuDown" then
			Wheel:scroll_by_amount(1)
			cursor_move_sfx:play()

		elseif event.GameButton == "MenuLeft" or event.GameButton == "MenuUp" then
			Wheel:scroll_by_amount(-1)
			cursor_move_sfx:play()

		elseif event.GameButton == "Start" then
			local choice = Wheel:get_actor_item_at_focus_pos()
			choice_made_sfx:play()
			choice.action()
		end
	end

	return false
end

---------------------------------------------------------------------
-- Primary ActorFrame and children
---------------------------------------------------------------------
local t = Def.ActorFrame{
	InitCommand=function(self)
		-- self:xy(0,0)
		self:xy(0,0):halign(1)

		-- set_info_set() takes two arguments:
		--		a table of meaningful data to divvy up to wheel items
		--		the index of which item we want to initially give focus to
		Wheel:set_info_set(Choices, 1)

		-- queue the next command so that we can actually GetTopScreen()
		self:queuecommand("Capture")
	end,
	CaptureCommand=function(self)

		-- attach our InputHandler to the TopScreen and pass it this ActorFrame
		-- so we can manipulate stuff more easily from there
		SCREENMAN:GetTopScreen():AddInputCallback( InputHandler )
	end,
	TransitionScreenCommand=function(self)
		SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
	end,
	OnCommand=function(self)
		self:decelerate(0.333):x(_screen.w/3.5)
	end,
	OffCommand=function(self)
		self:accelerate(0.2):x(-_screen.w/3.5)
	end,



	Def.Quad{
		InitCommand=function(self)
			self:diffuse(0,0,0,0.75):zoomto(_screen.w/3.5, _screen.h):halign(1):y(_screen.cy)
		end
	},

}

t[#t+1] = Wheel:create_actors( "Wheel", #Choices, wheel_item_mt, -_screen.w/3.5 + 20 , _screen.cy-100 )

---------------------------------------------------------------------
-- Sounds

t[#t+1] = Def.Sound{
	File=THEME:GetPathS("Common", "value.ogg"),
	InitCommand=function(self) cursor_move_sfx = self end
}

t[#t+1] = Def.Sound{
	File=THEME:GetPathS("Common", "start.ogg"),
	InitCommand=function(self) choice_made_sfx = self end
}


return t